


/**
 ******************************************************************************
 *
 * @file        MG04_06_Global.h
 * @brief       MG04-06 Global H file
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#ifndef _GLOBAL_H
#define _GLOBAL_H


#include "MG32.h"
#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_TM_DRV.h"
#include "BSP_SARADCKey.h"
#include "BSP_TouchKey.h"
#include "BSP_ARGB.h"
#include "BSP_SPILCD.h"
#include "BSP_SPIFlash.h"
#include "BSP_UARTCOM.h"

/**
 * @name  Define #1
 */
///@{

/*Touch Key flow state*/
#define TOUCHKEY_KEY0_CHARGE        0
#define TOUCHKEY_TPAD01_SAMPLE      1
#define TOUCHKEY_KEY1_CHARGE        2
#define TOUCHKEY_TPAD23_SAMPLE      3


/*MG04_06 main state */
#define MG04_06_STATE_TOTAL                   0x06     
#define MG04_06_STATE_MAIN_FRONTPAGE          0x00     /*!< MG04-06 state - Front page*/
#define MG04_06_STATE_MAIN_ARGBFRONTPAGE      0x01     /*!< MG04-06 state - ARGB front page*/
#define MG04_06_STATE_MAIN_ARGBMODEPAGE       0x02     /*!< MG04-06 state - ARGB mode page*/
#define MG04_06_STATE_MAIN_ARGB2COLORPAGE     0x03     /*!< MG04-06 state - ARGB color0 or color1 select page*/
#define MG04_06_STATE_MAIN_ARGBCOLORPAGE      0x04     /*!< MG04-06 state - ARGB color setting page*/
#define MG04_06_STATE_MAIN_SETTINGPAGE        0x05     /*!< MG04-06 state - Setting page.*/


/*MG04_06 sub. state*/

#define MG04_06_STATE_SUB_IDLETIME            0


/*MG04_06 Enter function */
#define MG04_06_FUNCTION_SETTINGLOCK          0x00
#define MG04_06_FUNCTION_ESC                  0x01
#define MG04_06_FUNCTION_AUTO                 0x02
#define MG04_06_FUNCTION_ARGBMODE             0x03
#define MG04_06_FUNCTION_ARGBCOLOR            0x04
#define MG04_06_FUNCTION_NEXTPAGE             0x80


/*Key ( SARADC Key , touch key)*/
#define MG04_06_TOTAL_KEY           8
#define MG04_06_TOTAL_SKEY          4
#define MG04_06_TOTAL_TPKEY         4

#define MG04_06_TPKEY_SHIFT         4
#define MG04_06_KEY_FLAG            1


/*LCD Control*/
#define LCD_FLASH_BACKGROUND_SIZE   153120        /*!< Backgroud picture size which save in MX25R6435F Flash.*/


#define LCD_DYNAMICUPDATE_OPITIONFRAME   0x01
#define LCD_DYNAMICUPDATE_OTHER          0x02


/*Time base handle*/
#define MG04_06_TIMEHANDLE_BACKGROUND    4


/*Idle Handle*/
#define MG04_06_IDLESTATE_NO         0x00
#define MG04_06_IDLESTATE_FORNTPAGE  0x01
#define MG04_06_IDLESTATE_TOSLEEP    0x02
#define MG04_06_IDLESTATE_SLEEP      0x04
#define MG04_06_IDLESTATE_WAKEUP     0x08

/*Auto mode (Demo mode) Handle*/
#define ARGB_AUTO_MODE                    ARGB_MODE_TOTAL
#define ARGB_AUTO_DRAMA_SINGLE_COLOR      0
#define ARGB_AUTO_DRAMA_CROSS             1
#define ARGB_AUTO_DRAMA_NET               2
#define ARGB_AUTO_DRAMA_STRING            3


///@}



/** 
 * @name  typedef 
 */
///@{



/*! @enum   Status_TypeDef
    @brief  Common status
*/
typedef enum
{
    Idle,
    Busy,
    Fail,
}Status_TypeDef;


/*! @struct MG04_06_TypeDef
    @brief  MG04_06 control struct type.
*/
typedef struct __attribute__((packed))
{
    uint32_t volatile TimeBase_Flag;    
    uint32_t volatile TimeBaseCount;
    uint32_t          IdleTime;
    uint32_t          IdleTimeCompare;
    uint8_t           IdleState;
    
    uint8_t           MainState;
    uint8_t           SubState;
    uint8_t           SubStateBefore;
    uint16_t const    *pLCDframeTable;
    uint8_t  const    *pLCDEnterTable;
    FunctionalState   SubStateLock;
    
    uint8_t           ESC_FunctionFlag;
    
    uint8_t           KeyStatus[MG04_06_TOTAL_KEY];
    uint8_t           KeyStatus_ChangeFlag;
                      
    uint32_t          SKey_BeforeStatus;
    uint32_t          SKey_NowStatus;
                      
    uint16_t          Touchkey_State;
    uint16_t          TouchKey_BeforeStatus;
    uint16_t          TouchKey_NowStatus;
                    
    Status_TypeDef    LCD_Status;
    uint16_t          LCD_BackgroundColor;
    uint32_t          LCD_BackgroundFlashAddress;
    
    uint8_t           LCD_BackgroundUpdateFlag;
    uint8_t           LCD_DynamicUpdateFlag;

    FunctionalState   ARGB_Auto;
    
    uint8_t           ARGB_AUTO_Count;
    uint8_t           ARGB_AUTO_DramaMainCount;
    uint8_t           ARGB_AUTO_DramaSubCount;
    
    uint8_t           ARGB_AUTO_CountCompare;
    uint8_t           ARGB_AUTO_DramaMainCountCompare;
    uint8_t           ARGB_AUTO_DramaSubCountCompare;
    uint8_t           ARGBMode_Index;
    uint8_t           ARGBColor_Index;
    uint16_t          ARGBColor_Opition[(ARGB_MODE_TOTAL - 1) *2];
    
}MG04_06_TypeDef;


///@}



/** 
 * @name  variables 
 */
///@{

extern MG04_06_TypeDef MG04_06_CTR;
extern uint32_t const LCD_BackGroundFlashTable[6];


///@}

/**
 * @name  Define #2
 */
///@{

/*Key status buffer*/
#define BK_ESC              MG04_06_CTR.KeyStatus[0]   /*!< Button (SARADC) KEY0*/
#define BK_UP               MG04_06_CTR.KeyStatus[1]   /*!< Button (SARADC) KEY1*/
#define BK_ENTER            MG04_06_CTR.KeyStatus[2]   /*!< Button (SARADC) KEY2*/
#define BK_DOWN             MG04_06_CTR.KeyStatus[3]   /*!< Button (SARADC) KEY3*/
#define TK_FUN_ARGBMODE     MG04_06_CTR.KeyStatus[4]   /*!< Touch KEY0*/
#define TK_FUN_COLOR0       MG04_06_CTR.KeyStatus[5]   /*!< Touch KEY1*/
#define TK_FUN_COLOR1       MG04_06_CTR.KeyStatus[6]   /*!< Touch KEY2*/
#define TK_FUN_AUTO         MG04_06_CTR.KeyStatus[7]   /*!< Touch KEY3*/
///@}


/** 
 * @name  Function 
 */
///@{


void API_LCD_BackgroundUpdate(void);
void API_LCD_DynamicUpdate(void);
void API_DetectSARADCKey(void);
void API_DetectTouchKey(void);
void API_Key_Handle(void);
void API_ARGBDrama_Handle(void);
void API_IdleHandle(void);
///@}


#endif

